/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class FilerConsumerPreMoveDoneFileNameTest
extends ContextTestSupport {
    @Test
    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        Awaitility.await().pollDelay(250L, TimeUnit.MILLISECONDS).untilAsserted(() -> this.assertMockEndpointsSatisfied());
        this.resetMocks();
        this.oneExchangeDone.reset();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"", "CamelFileName", (Object)"ready");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        FilerConsumerPreMoveDoneFileNameTest.assertFileNotExists(this.testFile("ready"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FilerConsumerPreMoveDoneFileNameTest.this.fileUri("?preMove=work/work-${file:name}&doneFileName=ready&initialDelay=0&delay=10")).to("mock:result");
            }
        };
    }
}

