/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FilerConsumerMoveFailedDoneFileNameTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:input").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"", "CamelFileName", (Object)"done");
        this.assertMockEndpointsSatisfied(1L, TimeUnit.SECONDS);
        this.oneExchangeDone.matchesWaitTime();
        FilerConsumerMoveFailedDoneFileNameTest.assertFileNotExists(this.testFile("done"));
        FilerConsumerMoveFailedDoneFileNameTest.assertFileExists(this.testFile("failed/" + TEST_FILE_NAME));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FilerConsumerMoveFailedDoneFileNameTest.this.fileUri("?doneFileName=done&initialDelay=0&delay=10&moveFailed=failed")).to("mock:input")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

