/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class FilerConsumerDualDoneFileNameTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_1 = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_2 = "bye" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testTwoDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.template.sendBodyAndHeader(this.fileUri("?doneFileName=${file:name}.ready"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME_1);
        this.template.sendBodyAndHeader(this.fileUri("?doneFileName=${file:name}.ready"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME_2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOneDoneFileMissing() {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri("?doneFileName=${file:name}.ready"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME_1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME_2);
        Awaitility.await().pollDelay(250L, TimeUnit.MILLISECONDS).untilAsserted(() -> this.assertMockEndpointsSatisfied());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FilerConsumerDualDoneFileNameTest.this.fileUri("?doneFileName=${file:name}.ready&initialDelay=0&delay=10")).to("mock:result");
            }
        };
    }
}

