/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class FilerConsumerDoneFileNoopTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").setResultMinimumWaitTime(50L);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.oneExchangeDone.reset();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"", "CamelFileName", (Object)"done");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        FilerConsumerDoneFileNoopTest.assertFileExists(this.testFile("done"));
        FilerConsumerDoneFileNoopTest.assertFileExists(this.testFile(TEST_FILE_NAME));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FilerConsumerDoneFileNoopTest.this.fileUri("?initialDelay=0&delay=10&doneFileName=done&noop=true")).to("mock:result");
            }
        };
    }
}

