/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class FilerConsumerDoneFileNameDeleteTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        Awaitility.await().pollDelay(50L, TimeUnit.MILLISECONDS).untilAsserted(() -> this.assertMockEndpointsSatisfied());
        this.resetMocks();
        this.oneExchangeDone.reset();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"", "CamelFileName", (Object)"done");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        FilerConsumerDoneFileNameDeleteTest.assertFileNotExists(this.testFile("done"));
        FilerConsumerDoneFileNameDeleteTest.assertFileNotExists(this.testFile(TEST_FILE_NAME));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FilerConsumerDoneFileNameDeleteTest.this.fileUri("?doneFileName=done&delete=true&initialDelay=0&delay=10")).to("mock:result");
            }
        };
    }
}

