/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileURLDecodingTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.context.stop();
        super.tearDown();
    }

    @Test
    public void testSimpleFile() throws Exception {
        this.assertTargetFile("data.txt", "data.txt");
    }

    @Test
    public void testFilePlus() throws Exception {
        this.assertTargetFile("data .txt", "data .txt");
    }

    @Test
    public void testFileSpace() throws Exception {
        this.assertTargetFile("data%20.txt", "data .txt");
    }

    @Test
    public void testFile2B() throws Exception {
        this.assertTargetFile("data .txt", "data .txt");
    }

    @Test
    public void testFileRaw2B() throws Exception {
        this.assertTargetFile("RAW(data%2B.txt)", "data%2B.txt");
    }

    @Test
    public void testFileRawPlus() throws Exception {
        this.assertTargetFile("RAW(data+.txt)", "data+.txt");
    }

    @Test
    public void testFileRawSpace() throws Exception {
        this.assertTargetFile("RAW(data%20.txt)", "data%20.txt");
    }

    @Test
    public void testFileWithTwoHundredPercent() throws Exception {
        this.assertTargetFile("RAW(data%%.txt)", "data%%.txt");
    }

    private void assertTargetFile(final String encoded, String expected) throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to(FileURLDecodingTest.this.fileUri("?fileName=" + encoded));
            }
        });
        this.context.start();
        String result = (String)this.template.requestBody("direct:start", (Object)"Kermit", String.class);
        Assertions.assertEquals((Object)"Kermit", (Object)result);
        FileURLDecodingTest.assertFileExists(this.testFile(expected), "Kermit");
    }
}

