/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileToFileWithFlattenTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.template.sendBodyAndHeader(this.fileUri("flatten-in"), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUri("flatten-in"), (Object)"Hello World", "CamelFileName", (Object)"sub/hello.txt");
        this.template.sendBodyAndHeader(this.fileUri("flatten-in"), (Object)"Goodday World", "CamelFileName", (Object)"sub/sub2/goodday.txt");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.context.stop();
        super.tearDown();
    }

    @Test
    public void testFlatternConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(FileToFileWithFlattenTest.this.fileUri("flatten-in?initialDelay=0&delay=10&recursive=true&flatten=true")).to(new String[]{FileToFileWithFlattenTest.this.fileUri("flatten-out"), "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedFileExists(this.testFile("flatten-out/bye.txt"));
        mock.expectedFileExists(this.testFile("flatten-out/hello.txt"));
        mock.expectedFileExists(this.testFile("flatten-out/goodday.txt"));
        mock.expectedFileExists(this.testFile("flatten-in/.camel/bye.txt"));
        mock.expectedFileExists(this.testFile("flatten-in/sub/.camel/hello.txt"));
        mock.expectedFileExists(this.testFile("flatten-in/sub/sub2/.camel/goodday.txt"));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFlatternProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(FileToFileWithFlattenTest.this.fileUri("flatten-in?initialDelay=0&delay=10&recursive=true")).to(new String[]{FileToFileWithFlattenTest.this.fileUri("flatten-out?flatten=true"), "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedFileExists(this.testFile("flatten-out/bye.txt"));
        mock.expectedFileExists(this.testFile("flatten-out/hello.txt"));
        mock.expectedFileExists(this.testFile("flatten-out/goodday.txt"));
        mock.expectedFileExists(this.testFile("flatten-in/.camel/bye.txt"));
        mock.expectedFileExists(this.testFile("flatten-in/sub/.camel/hello.txt"));
        mock.expectedFileExists(this.testFile("flatten-in/sub/sub2/.camel/goodday.txt"));
        this.assertMockEndpointsSatisfied();
    }
}

