/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileToFileNioLowBufferTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testFileToFileNioLowBuffer() throws Exception {
        String body = "1234567890123456789012345678901234567890";
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile("out/" + TEST_FILE_NAME), body);
        this.template.sendBodyAndHeader(this.fileUri("in"), (Object)body, "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(FileToFileNioLowBufferTest.this.fileUri("in?initialDelay=0&delay=10")).convertBodyTo(String.class)).to(FileToFileNioLowBufferTest.this.fileUri("out?bufferSize=4"))).to("mock:result");
            }
        };
    }
}

