/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileSplitXPathCharsetTest
extends ContextTestSupport {
    private Path inputCsv;
    private Path inputXml;

    @BeforeEach
    public void setUpTemporaryFiles() {
        this.inputXml = this.testFile("input.xml");
        this.inputCsv = this.testFile("input.csv");
    }

    @Test
    public void testCsv() throws Exception {
        MockEndpoint out = this.getMockEndpoint("mock:result");
        out.expectedMessageCount(3);
        out.expectedBodiesReceived(new Object[]{"abc", "xyz", "\u00e5\u00e4\u00f6"});
        Files.write(this.inputCsv, "abc,xyz,\u00e5\u00e4\u00f6".getBytes(StandardCharsets.ISO_8859_1), new OpenOption[0]);
        out.assertIsSatisfied();
    }

    @Test
    public void testXml() throws Exception {
        MockEndpoint out = this.getMockEndpoint("mock:result");
        out.expectedMessageCount(3);
        out.expectedBodiesReceived(new Object[]{"abc", "xyz", "\u00e5\u00e4\u00f6"});
        InputStream resourceAsStream = this.getClass().getResourceAsStream("FileSplitXPathCharsetTest-input.xml");
        Assertions.assertNotNull((Object)resourceAsStream, (String)"FileSplitXPathCharsetTest-input.xml not found");
        Files.copy(resourceAsStream, this.inputXml, new CopyOption[0]);
        out.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from(FileSplitXPathCharsetTest.this.fileUri("?charset=ISO-8859-1&include=.*\\.csv")).split().tokenize(",")).to("mock:result");
                ((SplitDefinition)this.fromF(FileSplitXPathCharsetTest.this.fileUri("?charset=ISO-8859-1&include=.*\\.xml"), new Object[0]).split().xpath("/foo/bar/text()")).to("mock:result");
            }
        };
    }
}

