/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.SimpleExpression;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileSplitInSplitTest
extends ContextTestSupport {
    private final String comma = ",";

    @Test
    public void testConcurrentAppend() throws Exception {
        int i;
        StringBuilder sb = new StringBuilder();
        int size = 3;
        for (i = 0; i < size; ++i) {
            sb.append("Block1 Line ").append(i).append(LS);
        }
        sb.append(",");
        for (i = 10; i < size + 10; ++i) {
            sb.append("Block2 Line ").append(i).append(LS);
        }
        this.template.sendBodyAndHeader(this.fileUri(), (Object)sb.toString(), "CamelFileName", (Object)"input.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
        FileSplitInSplitTest.assertFileExists(this.testFile("outbox/result0.txt"));
        String txt = new String(Files.readAllBytes(this.testFile("outbox/result0.txt")));
        Assertions.assertNotNull((Object)txt);
        String[] lines = txt.split(LS);
        Assertions.assertEquals((int)(size + 1), (int)lines.length, (String)("Should be " + (size + 1) + " lines"));
        txt = new String(Files.readAllBytes(this.testFile("outbox/result1.txt")));
        Assertions.assertNotNull((Object)txt);
        lines = txt.split(LS);
        Assertions.assertEquals((int)(size + 1), (int)lines.length, (String)("Should be " + (size + 1) + " lines"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from(FileSplitInSplitTest.this.fileUri("?initialDelay=0&delay=10")).routeId("foo").autoStartup(false).split((Expression)this.body().tokenize(",")).parallelProcessing().streaming().setProperty("split", (Expression)new SimpleExpression("${exchangeProperty.CamelSplitIndex}"))).split((Expression)this.body().tokenize(LS)).parallelProcessing().streaming().setBody((Expression)this.body().append((Object)":Status=OK").append((Object)LS))).to(FileSplitInSplitTest.this.fileUri("outbox?fileExist=Append&fileName=result${exchangeProperty.split}.txt"))).end().setBody((Expression)new SimpleExpression("${exchangeProperty.split} complete")).to(FileSplitInSplitTest.this.fileUri("outbox?fileExist=Append&fileName=result${exchangeProperty.split}.txt")).end().to("mock:result");
            }
        };
    }
}

