/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Comparator;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class FileSorterRefTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("mySorter", new MyFileSorter());
        return jndi;
    }

    @Test
    public void testSortFiles() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello Copenhagen", "CamelFileName", (Object)"copenhagen.txt");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileSorterRefTest.this.fileUri("?initialDelay=0&delay=10&sorter=#mySorter")).convertBodyTo(String.class)).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello Copenhagen", "Hello London", "Hello Paris"});
        this.assertMockEndpointsSatisfied();
    }

    public static class MyFileSorter<T>
    implements Comparator<GenericFile<T>> {
        @Override
        public int compare(GenericFile<T> o1, GenericFile<T> o2) {
            return o1.getFileName().compareToIgnoreCase(o2.getFileName());
        }
    }
}

