/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileSortByNestedExpressionTest
extends ContextTestSupport {
    private void prepareFolder(String folder) {
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello Copenhagen", "CamelFileName", (Object)"copenhagen.xml");
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello Dublin", "CamelFileName", (Object)"dublin.txt");
    }

    @Test
    public void testSortNestedFiles() throws Exception {
        this.prepareFolder("a");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileSortByNestedExpressionTest.this.fileUri("a/?initialDelay=0&delay=10&sortBy=file:ext;file:name")).convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello Dublin", "Hello London", "Hello Paris", "Hello Copenhagen"});
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSortNestedFilesReverse() throws Exception {
        this.prepareFolder("b");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileSortByNestedExpressionTest.this.fileUri("b/?initialDelay=0&delay=10&sortBy=file:ext;reverse:file:name")).convertBodyTo(String.class)).to("mock:reverse");
            }
        });
        this.context.start();
        MockEndpoint reverse = this.getMockEndpoint("mock:reverse");
        reverse.expectedBodiesReceived(new Object[]{"Hello Paris", "Hello London", "Hello Dublin", "Hello Copenhagen"});
        this.assertMockEndpointsSatisfied();
    }
}

