/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.LINUX}, architectures={"ppc64le"}, disabledReason="This test does not run reliably multiple platforms (see CAMEL-21438)")
public class FileSortByIgnoreCaseExpressionTest
extends ContextTestSupport {
    private void prepareFolder(String folder) {
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello Paris", "CamelFileName", (Object)"report-3.dat");
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello London", "CamelFileName", (Object)"REPORT-2.txt");
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello Copenhagen", "CamelFileName", (Object)"Report-1.xml");
    }

    @Test
    public void testSortFilesByNameWithCase() throws Exception {
        this.prepareFolder("a");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileSortByIgnoreCaseExpressionTest.this.fileUri("a/?sortBy=file:name&initialDelay=250&delay=1000")).convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello London", "Hello Copenhagen", "Hello Paris"});
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSortFilesByNameNoCase() throws Exception {
        this.prepareFolder("b");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileSortByIgnoreCaseExpressionTest.this.fileUri("b/?initialDelay=0&delay=10&sortBy=ignoreCase:file:name")).convertBodyTo(String.class)).to("mock:nocase");
            }
        });
        this.context.start();
        MockEndpoint nocase = this.getMockEndpoint("mock:nocase");
        nocase.expectedBodiesReceived(new Object[]{"Hello Copenhagen", "Hello London", "Hello Paris"});
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSortFilesByNameNoCaseReverse() throws Exception {
        this.prepareFolder("c");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileSortByIgnoreCaseExpressionTest.this.fileUri("c/?initialDelay=0&delay=10&sortBy=reverse:ignoreCase:file:name")).convertBodyTo(String.class)).to("mock:nocasereverse");
            }
        });
        this.context.start();
        MockEndpoint nocasereverse = this.getMockEndpoint("mock:nocasereverse");
        nocasereverse.expectedBodiesReceived(new Object[]{"Hello Paris", "Hello London", "Hello Copenhagen"});
        this.assertMockEndpointsSatisfied();
    }
}

