/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileSortByExpressionTest
extends ContextTestSupport {
    private void prepareFolder(String folder) {
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello Paris", "CamelFileName", (Object)"paris.dat");
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        this.template.sendBodyAndHeader(this.fileUri(folder), (Object)"Hello Copenhagen", "CamelFileName", (Object)"copenhagen.xml");
    }

    @Test
    public void testSortFiles() throws Exception {
        this.prepareFolder("a");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(FileSortByExpressionTest.this.fileUri("a/?initialDelay=0&delay=10&sortBy=file:ext")).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris", "Hello London", "Hello Copenhagen"});
        this.assertMockEndpointsSatisfied(1L, TimeUnit.SECONDS);
    }

    @Test
    public void testSortFilesReverse() throws Exception {
        this.prepareFolder("b");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileSortByExpressionTest.this.fileUri("b/?initialDelay=0&delay=10&sortBy=reverse:file:ext")).convertBodyTo(String.class)).to("mock:reverse");
            }
        });
        MockEndpoint reverse = this.getMockEndpoint("mock:reverse");
        reverse.expectedBodiesReceived(new Object[]{"Hello Copenhagen", "Hello London", "Hello Paris"});
        this.assertMockEndpointsSatisfied(1L, TimeUnit.SECONDS);
    }
}

