/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileRouteOnDosWithNoVolTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private String path;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.path = this.testDirectory("dosnovol").toAbsolutePath().toString();
        if (FileUtil.isWindows()) {
            this.path = StringHelper.after((String)this.path, (String)":\\", (String)this.path).replace('\\', '/');
        }
        super.setUp();
    }

    @Test
    public void testRouteFileToFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.path + "/route/out/" + TEST_FILE_NAME);
        this.template.sendBodyAndHeader("file://" + this.path + "/route/poller", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteFromFileOnly() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://" + this.path + "/from/poller", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteToFileOnly() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.path + "/to/out/" + TEST_FILE_NAME);
        this.template.sendBodyAndHeader("direct:report", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("file://" + FileRouteOnDosWithNoVolTest.this.path + "/route/poller?initialDelay=0&delay=10").to(new String[]{"file://" + FileRouteOnDosWithNoVolTest.this.path + "/route/out", "mock:result"});
                this.from("file://" + FileRouteOnDosWithNoVolTest.this.path + "/from/poller?initialDelay=0&delay=10").to("mock:result");
                this.from("direct:report").to(new String[]{"file://" + FileRouteOnDosWithNoVolTest.this.path + "/to/out", "mock:result"});
            }
        };
    }
}

