/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileRenameReadLockMustUseMarkerFileTest
extends ContextTestSupport {
    @Test
    public void testCamelLockFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        ((MockValueBuilder)mock.message(0).header("CamelFileName")).isEqualTo((Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        FileRenameReadLockMustUseMarkerFileTest.assertFileNotExists(this.testFile("bye.txt.camelLock"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(FileRenameReadLockMustUseMarkerFileTest.this.fileUri("?readLock=rename&initialDelay=0&delay=10")).routeId("foo").autoStartup(false).process(new Processor(){

                    public void process(Exchange exchange) {
                        String name = String.valueOf(exchange.getIn().getHeader("CamelFilePath")) + ".camelLock";
                        File lock = new File(name);
                        Assertions.assertTrue((boolean)lock.exists(), (String)("Lock file should exist: " + name));
                    }
                })).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

