/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="Flaky test")
public class FileRecursiveNoopTest
extends ContextTestSupport {
    @BeforeEach
    void sendMessages() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"a", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"b", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"a2", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(this.fileUri("bar"), (Object)"c", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader(this.fileUri("bar"), (Object)"b2", "CamelFileName", (Object)"b.txt");
    }

    @Test
    public void testRecursiveNoop() throws Exception {
        this.context.getRouteController().startAllRoutes();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"a", "b", "a2", "c", "b2"});
        mock.assertIsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"c2"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"c2", "CamelFileName", (Object)"c.txt");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileRecursiveNoopTest.this.fileUri("?initialDelay=0&delay=10&recursive=true&noop=true")).convertBodyTo(String.class)).autoStartup(false).to("mock:result");
            }
        };
    }
}

