/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileProducerToDMoveExistingTest
extends ContextTestSupport {
    @Test
    public void testMoveExisting() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("myDir", "out");
        headers.put("CamelFileName", "hello.txt");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.template.sendBodyAndHeaders("direct:start", (Object)"Bye World", headers);
        this.assertMockEndpointsSatisfied();
        FileProducerToDMoveExistingTest.assertFileExists(this.testFile("out/old-hello.txt"));
        FileProducerToDMoveExistingTest.assertFileExists(this.testFile("out/hello.txt"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").toD(FileProducerToDMoveExistingTest.this.fileUri("${header.myDir}?fileExist=Move&moveExisting=" + FileProducerToDMoveExistingTest.this.testDirectory("out").toString() + "/old-${file:onlyname}"))).to("mock:result");
            }
        };
    }
}

