/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileProducerTempFileExistsIssueTest
extends ContextTestSupport {
    public static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testIllegalConfigurationPrefix() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.getEndpoint(this.fileUri("?fileExist=Append&tempPrefix=foo")).createProducer());
        Assertions.assertEquals((Object)"You cannot set both fileExist=Append and tempPrefix/tempFileName options", (Object)e.getMessage());
    }

    @Test
    public void testIllegalConfigurationFileName() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.getEndpoint(this.fileUri("?fileExist=Append&tempFileName=foo")).createProducer());
        Assertions.assertEquals((Object)"You cannot set both fileExist=Append and tempPrefix/tempFileName options", (Object)e.getMessage());
    }

    @Test
    public void testWriteUsingTempPrefixButFileExist() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?tempPrefix=foo"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerTempFileExistsIssueTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
    }

    @Test
    public void testWriteUsingTempPrefixButBothFileExist() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"foohello.txt");
        this.template.sendBodyAndHeader(this.fileUri("?tempPrefix=foo"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerTempFileExistsIssueTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
    }

    @Test
    public void testWriteUsingTempPrefixButFileExistOverride() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?tempPrefix=foo&fileExist=Override"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerTempFileExistsIssueTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
    }

    @Test
    public void testWriteUsingTempPrefixButFileExistIgnore() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?tempPrefix=foo&fileExist=Ignore"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerTempFileExistsIssueTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Hello World");
    }

    @Test
    public void testWriteUsingTempPrefixButFileExistFail() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader(this.fileUri("?tempPrefix=foo&fileExist=Fail"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME));
        GenericFileOperationFailedException cause = FileProducerTempFileExistsIssueTest.assertIsInstanceOf(GenericFileOperationFailedException.class, e.getCause());
        Assertions.assertTrue((boolean)cause.getMessage().startsWith("File already exist"));
        FileProducerTempFileExistsIssueTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Hello World");
    }
}

