/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.stream.Stream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileProducerStreamTest
extends ContextTestSupport {
    @Test
    public void testStream() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        Stream<String> body = Stream.of("ABC", "DEF", "1234567890");
        this.template.sendBodyAndHeader("direct:start", body, "CamelFileName", (Object)"report.txt");
        this.assertMockEndpointsSatisfied();
        FileProducerStreamTest.assertFileExists(this.testFile("report.txt"), "ABCDEF1234567890");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to(FileProducerStreamTest.this.fileUri())).to("mock:result");
            }
        };
    }
}

