/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="This test is regularly flaky")
public class FileProducerRenameUsingCopyTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testMove() throws Exception {
        String body = "Hello Camel";
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile("done/" + TEST_FILE_NAME), "Hello Camel");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello Camel", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        Awaitility.await().untilAsserted(() -> {
            FileProducerRenameUsingCopyTest.assertFileExists(this.testFile("done/" + TEST_FILE_NAME));
            FileProducerRenameUsingCopyTest.assertFileNotExists(this.testFile(TEST_FILE_NAME));
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileProducerRenameUsingCopyTest.this.fileUri("?renameUsingCopy=true&move=done")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

