/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileProducerNoForcedWritesTest
extends ContextTestSupport {
    @Test
    public void testNoForcedWrites() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        FileProducerNoForcedWritesTest.assertFileExists(this.testFile("output.txt"));
        Assertions.assertEquals((Object)"Hello World", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)this.testFile("output.txt").toFile()));
        FileProducerNoForcedWritesTest.assertFileExists(this.testFile("output2.txt"));
        Assertions.assertEquals((Object)"Hello World", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)this.testFile("output2.txt").toFile()));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from(FileProducerNoForcedWritesTest.this.fileUri("?initialDelay=0&delay=10&noop=true")).multicast().to(new String[]{FileProducerNoForcedWritesTest.this.fileUri("?fileName=output.txt&forceWrites=false"), FileProducerNoForcedWritesTest.this.fileUri("?fileName=output2.txt&charset=iso-8859-1&forceWrites=false")})).to("mock:result");
            }
        };
    }
}

