/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileProducerMoveExistingTest
extends ContextTestSupport {
    public static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";
    public static final String TEST_FILE_NAME_2 = "howdy." + String.valueOf(UUID.randomUUID()) + ".txt";
    public static final String RENAMED_TEST_FILE_NAME = "renamed-" + TEST_FILE_NAME;

    @Test
    public void testExistingFileDoesNotExists() {
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(TEST_FILE_NAME));
        FileProducerMoveExistingTest.assertFileNotExists(this.testFile(RENAMED_TEST_FILE_NAME));
    }

    @Test
    public void testExistingFileExists() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
        FileProducerMoveExistingTest.assertFileExists(this.testFile(RENAMED_TEST_FILE_NAME), "Hello World");
    }

    @Test
    public void testExistingFileExistsTempFileName() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
        FileProducerMoveExistingTest.assertFileExists(this.testFile(RENAMED_TEST_FILE_NAME), "Hello World");
    }

    @Test
    public void testExistingFileExistsTempFileName2() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=renamed"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=renamed"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
        FileProducerMoveExistingTest.assertFileExists(this.testFile("renamed/" + TEST_FILE_NAME), "Hello World");
    }

    @Test
    public void testFailOnMoveExistingFileExistsEagerDeleteFalseTempFileName() throws Exception {
        String filename = TEST_FILE_NAME;
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp"), (Object)"First File", "CamelFileName", (Object)RENAMED_TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=false"), (Object)"Second File", "CamelFileName", (Object)filename);
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=false"), (Object)"Third File", "CamelFileName", (Object)filename);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(filename), "Third File");
        FileProducerMoveExistingTest.assertFileExists(this.testFile("renamed-" + filename), "First File");
    }

    @Test
    public void testExistingFileExistsTempFileNameMoveDynamicSubdirFullPath() throws Exception {
        String subdirPrefix = this.generateRandomString(5);
        String dynamicPath = "${file:parent}/" + subdirPrefix + "-${date:now:yyyyMMddHHmmssSSS}/${file:onlyname}";
        String tempFilename = "tempFileName=${file:onlyname}.temp&";
        this.testDynamicSubdir(subdirPrefix, dynamicPath, "tempFileName=${file:onlyname}.temp&");
    }

    @Test
    public void testExistingFileExistsTempFileNameMoveDynamicSubdir() throws Exception {
        String subdirPrefix = this.generateRandomString(5);
        String dynamicPath = subdirPrefix + "-${date:now:yyyyMMddHHmmssSSS}/";
        String tempFilename = "tempFileName=${file:onlyname}.temp&";
        this.testDynamicSubdir(subdirPrefix, dynamicPath, "tempFileName=${file:onlyname}.temp&");
    }

    @Test
    public void testExistingFileExistsMoveDynamicSubdir() throws Exception {
        String subdirPrefix = this.generateRandomString(5);
        String dynamicPath = subdirPrefix + "-${date:now:yyyyMMddHHmmssSSS}/";
        String tempFilename = "";
        this.testDynamicSubdir(subdirPrefix, dynamicPath, "");
    }

    @Test
    public void testExistingFileExistsMoveDynamicSubdirFullPath() throws Exception {
        String subdirPrefix = this.generateRandomString(5);
        String dynamicPath = "${file:parent}/" + subdirPrefix + "-${date:now:yyyyMMddHHmmssSSS}/${file:onlyname}";
        String tempFilename = "";
        this.testDynamicSubdir(subdirPrefix, dynamicPath, "");
    }

    private void testDynamicSubdir(String subdirPrefix, String dynamicPath, String tempFilename) throws IOException {
        String filename = TEST_FILE_NAME_2;
        String fileContent = "Hello World";
        this.template.sendBodyAndHeader(this.fileUri("?" + tempFilename + "fileExist=Move&moveExisting=" + dynamicPath), (Object)"Hello World", "CamelFileName", (Object)filename);
        this.template.sendBodyAndHeader(this.fileUri("?" + tempFilename + "fileExist=Move&moveExisting=" + dynamicPath), (Object)"Hello World", "CamelFileName", (Object)filename);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(filename), "Hello World");
        String[] directories = this.testDirectory().toFile().list((current, name) -> {
            String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
            return new File(current, name).isDirectory() && name.startsWith(subdirPrefix + "-" + date);
        });
        Assertions.assertNotNull((Object)directories, (String)"There should be a list of directories");
        Assertions.assertEquals((int)1, (int)directories.length);
        File movedFilePath = this.testFile(directories[0] + File.separator + filename).toFile();
        Assertions.assertTrue((boolean)movedFilePath.exists());
        Assertions.assertEquals((Object)"Hello World", (Object)this.context.getTypeConverter().convertTo(String.class, (Object)movedFilePath));
    }

    @Test
    public void testExistingFileExistsTempFileNameMoveSubDir() throws Exception {
        String filename = TEST_FILE_NAME_2;
        String fileContent = "Hello World";
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=archive"), (Object)"Hello World", "CamelFileName", (Object)filename);
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=archive"), (Object)"Hello World", "CamelFileName", (Object)filename);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(filename), "Hello World");
        FileProducerMoveExistingTest.assertFileExists(this.testFile(filename), "Hello World");
    }

    @Test
    public void testExistingFileExistsTempFileNameRename() throws Exception {
        String filename = TEST_FILE_NAME_2;
        String fileContent1 = "Hello World1";
        String fileContent2 = "Hello World2";
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=${file:onlyname}.${date:now:yyyyMMddHHmmssSSS}"), (Object)"Hello World1", "CamelFileName", (Object)filename);
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=${file:onlyname}.temp&fileExist=Move&moveExisting=${file:onlyname}.${date:now:yyyyMMddHHmmssSSS}"), (Object)"Hello World2", "CamelFileName", (Object)filename);
        String[] files = this.testDirectory().toFile().list((current, name) -> {
            String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
            return new File(current, name).isFile() && name.startsWith(filename + "." + date);
        });
        Assertions.assertNotNull((Object)files, (String)"There should be a list of files");
        Assertions.assertEquals((int)1, (int)files.length);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(files[0]), "Hello World1");
        FileProducerMoveExistingTest.assertFileExists(this.testFile(filename), "Hello World2");
    }

    @Test
    public void testExistingFileExistsMoveSubDir() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=backup"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=backup"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
        FileProducerMoveExistingTest.assertFileExists(this.testFile("backup/" + TEST_FILE_NAME), "Hello World");
    }

    @Test
    public void testFailOnMoveExistingFileExistsEagerDeleteTrue() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Old file", "CamelFileName", (Object)RENAMED_TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=true"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=true"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerMoveExistingTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
        FileProducerMoveExistingTest.assertFileExists(this.testFile(RENAMED_TEST_FILE_NAME), "Hello World");
    }

    @Test
    public void testFailOnMoveExistingFileExistsEagerDeleteFalse() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Old file", "CamelFileName", (Object)RENAMED_TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=false"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=false"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME), (String)"Should have thrown an exception");
        GenericFileOperationFailedException cause = FileProducerMoveExistingTest.assertIsInstanceOf(GenericFileOperationFailedException.class, e.getCause());
        Assertions.assertTrue((boolean)cause.getMessage().startsWith("Cannot move existing file"));
        FileProducerMoveExistingTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Hello World");
        FileProducerMoveExistingTest.assertFileExists(this.testFile(RENAMED_TEST_FILE_NAME), "Old file");
    }

    private String generateRandomString(int targetStringLength) {
        int leftLimit = 97;
        int rightLimit = 122;
        Random random = new Random();
        StringBuilder buffer = new StringBuilder(targetStringLength);
        for (int i = 0; i < targetStringLength; ++i) {
            int randomLimitedInt = leftLimit + (int)(random.nextFloat() * (float)(rightLimit - leftLimit + 1));
            buffer.append((char)randomLimitedInt);
        }
        return buffer.toString();
    }
}

