/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProducerMoveExistingStrategyTest
extends ContextTestSupport {
    public static final String TEST_FILE_NAME_NOEXT = "hello." + String.valueOf(UUID.randomUUID());
    public static final String TEST_FILE_NAME = TEST_FILE_NAME_NOEXT + ".txt";
    private final MyStrategy myStrategy = new MyStrategy();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myStrategy", (Object)this.myStrategy);
        return jndi;
    }

    @Test
    public void testExistingFileExists() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&moveExistingFileStrategy=#myStrategy"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&moveExistingFileStrategy=#myStrategy"), (Object)"Bye Existing World 1", "CamelFileName", (Object)TEST_FILE_NAME);
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&moveExistingFileStrategy=#myStrategy"), (Object)"Bye Existing World 2", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProducerMoveExistingStrategyTest.assertFileExists(this.testFile(TEST_FILE_NAME), "Bye Existing World 2");
        FileProducerMoveExistingStrategyTest.assertFileExists(this.testFile("renamed-" + TEST_FILE_NAME_NOEXT + "2.txt"), "Bye Existing World 1");
        FileProducerMoveExistingStrategyTest.assertFileExists(this.testFile("renamed-" + TEST_FILE_NAME_NOEXT + "1.txt"), "Hello World");
    }

    private static class MyStrategy
    implements FileMoveExistingStrategy {
        private static final Logger LOG = LoggerFactory.getLogger(MyStrategy.class);
        private int counter;

        private MyStrategy() {
        }

        public boolean moveExistingFile(GenericFileEndpoint<?> endpoint, GenericFileOperations<?> operations, String fileName) throws GenericFileOperationFailedException {
            Exchange dummy = endpoint.createExchange();
            String parent = FileUtil.onlyPath((String)fileName);
            String onlyName = FileUtil.stripPath((String)fileName);
            dummy.getIn().setHeader("CamelFileName", (Object)fileName);
            dummy.getIn().setHeader("CamelFileNameOnly", (Object)onlyName);
            dummy.getIn().setHeader("CamelFileParent", (Object)parent);
            Object to = (String)endpoint.getMoveExisting().evaluate(dummy, String.class);
            ++this.counter;
            String fileNameWithoutExtension = ((String)to).substring(0, ((String)to).lastIndexOf(46)) + this.counter;
            to = fileNameWithoutExtension + ((String)to).substring(((String)to).lastIndexOf(46));
            to = FileUtil.normalizePath((String)to);
            if (ObjectHelper.isEmpty((String)to)) {
                throw new GenericFileOperationFailedException("moveExisting evaluated as empty String, cannot move existing file: " + fileName);
            }
            File toFile = new File((String)to);
            String directory = toFile.getParent();
            boolean absolute = FileUtil.isAbsolute((File)toFile);
            if (directory != null && !operations.buildDirectory(directory, absolute)) {
                LOG.debug("Cannot build directory [{}] (could be because of denied permissions)", (Object)directory);
            }
            if (operations.existsFile((String)to)) {
                if (endpoint.isEagerDeleteTargetFile()) {
                    LOG.trace("Deleting existing file: {}", to);
                    if (!operations.deleteFile((String)to)) {
                        throw new GenericFileOperationFailedException("Cannot delete file: " + (String)to);
                    }
                } else {
                    throw new GenericFileOperationFailedException("Cannot moved existing file from: " + fileName + " to: " + (String)to + " as there already exists a file: " + (String)to);
                }
            }
            LOG.trace("Moving existing file: {} to: {}", (Object)fileName, to);
            if (!operations.renameFile(fileName, (String)to)) {
                throw new GenericFileOperationFailedException("Cannot rename file from: " + fileName + " to: " + (String)to);
            }
            return true;
        }
    }
}

