/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileProducerJailStartingDirectoryTest
extends ContextTestSupport {
    @Test
    public void testWriteOutsideStartingDirectory() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelFileName", (Object)"hello.txt"), (String)"Should have thrown exception");
        IllegalArgumentException iae = FileProducerJailStartingDirectoryTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertTrue((boolean)iae.getMessage().contains("as the filename is jailed to the starting directory"));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWriteInsideStartingDirectory() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "CamelFileName", (Object)"outbox/bye.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").setHeader("CamelFileName", (Expression)this.simple("../${file:name}"))).to(FileProducerJailStartingDirectoryTest.this.fileUri("outbox"))).to("mock:result");
            }
        };
    }
}

