/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileProducerFileExistOverrideNoFileBeforeTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testOverride() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME), "Bye World");
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Override"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileProducerFileExistOverrideNoFileBeforeTest.this.fileUri("?noop=true&delay=1000")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

