/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileProducerFileExistFailTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME), "Hello World");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        String fileUriStr = this.fileUri("?fileExist=Fail");
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader(fileUriStr, (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME));
        GenericFileOperationFailedException cause = FileProducerFileExistFailTest.assertIsInstanceOf(GenericFileOperationFailedException.class, e.getCause());
        Assertions.assertEquals((Object)FileUtil.normalizePath((String)("File already exist: " + this.testFile(TEST_FILE_NAME).toString() + ". Cannot write new file.")), (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileProducerFileExistFailTest.this.fileUri("?noop=true&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

