/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileProducerFileExistAppendTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_1 = "test1" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_2 = "test2" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_OUT = "out" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testAppend() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World\n", "CamelFileName", (Object)TEST_FILE_NAME);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World\nBye World"});
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME), "Hello World\nBye World");
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Append"), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAppendFileByFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Row 1\n", "CamelFileName", (Object)TEST_FILE_NAME_1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Row 2\n", "CamelFileName", (Object)TEST_FILE_NAME_2);
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Append"), (Object)this.testFile(TEST_FILE_NAME_1).toFile(), "CamelFileName", (Object)TEST_FILE_NAME_OUT);
        this.template.sendBodyAndHeader(this.fileUri("?fileExist=Append"), (Object)this.testFile(TEST_FILE_NAME_2).toFile(), "CamelFileName", (Object)TEST_FILE_NAME_OUT);
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME_OUT), "Row 1\nRow 2\n");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileProducerFileExistAppendTest.this.fileUri("?noop=true&initialDelay=0&delay=10")).autoStartup(false).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

