/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileProducerFileBodyGetsMovedTest
extends ContextTestSupport {
    @Test
    public void testStoreFileExchangeBodyIsFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedFileExists(this.testFile("testStoreFile"));
        mock.expectedMessageCount(1);
        File temporaryFile = File.createTempFile("camel", "test");
        this.template.requestBodyAndHeader("direct:in", (Object)temporaryFile, "CamelFileLocalWorkPath", (Object)temporaryFile.getAbsolutePath());
        mock.assertIsSatisfied();
        Assertions.assertFalse((boolean)temporaryFile.exists(), (String)"Temporary body file should have been moved, not copied");
    }

    @Test
    public void testStoreFileExchangeBodyIsWrappedFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedFileExists(this.testFile("testStoreFile"));
        mock.expectedMessageCount(1);
        File temporaryFile = File.createTempFile("camel", "test");
        this.template.requestBodyAndHeader("direct:in", (Object)temporaryFile, "CamelFileLocalWorkPath", (Object)temporaryFile.getAbsolutePath());
        mock.assertIsSatisfied();
        Assertions.assertFalse((boolean)temporaryFile.exists(), (String)"Temporary body file should have been moved, not copied");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:in").to(FileProducerFileBodyGetsMovedTest.this.fileUri("?fileName=testStoreFile"))).to("mock:result");
            }
        };
    }
}

