/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class FileProducerExpressionTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myguidgenerator", (Object)new MyGuidGenerator());
        return jndi;
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testProducerFileNameHeaderNotEvaluated() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"$simple{myfile-${id}}.txt");
        FileProducerExpressionTest.assertFileExists(this.testFile("$simple{myfile-${id}}.txt"));
    }

    @Test
    public void testProduceBeanByExpression() {
        this.template.sendBody(this.fileUri("?fileName=${bean:myguidgenerator}.bak"), (Object)"Hello World");
        FileProducerExpressionTest.assertFileExists(this.testFile("123.bak"));
    }

    @Test
    public void testProducerDateByHeader() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)this.context.resolveLanguage("simple").createExpression("myfile-${date:now:yyyyMMdd}.txt"));
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        FileProducerExpressionTest.assertFileExists(this.testFile("myfile-" + date + ".txt"));
    }

    @Test
    public void testProducerDateByExpression() {
        this.template.sendBody(this.fileUri("?fileName=myfile-${date:now:yyyyMMdd}.txt"), (Object)"Hello World");
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        FileProducerExpressionTest.assertFileExists(this.testFile("myfile-" + date + ".txt"));
    }

    @Test
    public void testProducerComplexByExpression() {
        String expression = "target/filelanguageinbox/myfile-${bean:myguidgenerator.guid}-${date:now:yyyyMMdd}.txt";
        this.template.sendBody(this.fileUri("?jailStartingDirectory=false&fileName=" + expression), (Object)"Hello World");
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        FileProducerExpressionTest.assertFileExists(this.testFile("target/filelanguageinbox/myfile-123-" + date + ".txt"));
    }

    @Test
    public void testProducerSimpleWithHeaderByExpression() {
        this.template.sendBodyAndHeader(this.fileUri("?fileName=myfile-${in.header.foo}.txt"), (Object)"Hello World", "foo", (Object)"abc");
        FileProducerExpressionTest.assertFileExists(this.testFile("myfile-abc.txt"));
    }

    @Test
    public void testProducerWithDateHeader() {
        Calendar cal = Calendar.getInstance();
        cal.set(1974, 3, 20);
        Date date = cal.getTime();
        this.template.sendBodyAndHeader(this.fileUri("?fileName=mybirthday-${date:header.birthday:yyyyMMdd}.txt"), (Object)"Hello World", "birthday", (Object)date);
        FileProducerExpressionTest.assertFileExists(this.testFile("mybirthday-19740420.txt"));
    }

    public static class MyGuidGenerator {
        public String guid() {
            return "123";
        }
    }
}

