/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Date;
import java.util.Set;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS})
public class FileProducerDirectoryChmodOptionTest
extends ContextTestSupport {
    private static final String SUBDIR_NAME = "testdir";

    @Test
    public void testWriteValidNoDir() throws Exception {
        this.runChmodCheck("NoDir", null, "rwxr-xr-x");
    }

    @Test
    public void testWriteValidChmod0755() throws Exception {
        this.runChmodCheck("0755", "rwxrwxrwx", "rwxr-xr-x");
    }

    @Test
    public void testWriteValidChmod666() throws Exception {
        this.runChmodCheck("666", "rwxrwxrwx", "rw-rw-rw-");
    }

    private void runChmodCheck(String routeSuffix, String expectedDirectoryPermissions, String expectedPermissions) throws Exception {
        Set<PosixFilePermission> permissions;
        MockEndpoint mock = this.getMockEndpoint("mock:chmod" + routeSuffix);
        mock.expectedMessageCount(1);
        String testFileName = "chmod" + routeSuffix + ".txt";
        String testFileContent = "Writing file with chmod " + routeSuffix + " option at " + String.valueOf(new Date());
        String testFilePath = Path.of(SUBDIR_NAME, testFileName).toString();
        mock.expectedFileExists(this.testFile(testFilePath), testFileContent);
        this.template.sendBodyAndHeader("direct:write" + routeSuffix, (Object)testFileContent, "CamelFileName", (Object)testFilePath);
        if (expectedDirectoryPermissions != null) {
            permissions = Files.getPosixFilePermissions(this.testDirectory(SUBDIR_NAME), LinkOption.NOFOLLOW_LINKS);
            Assertions.assertEquals((Object)expectedDirectoryPermissions, (Object)PosixFilePermissions.toString(permissions));
            Assertions.assertEquals((int)expectedDirectoryPermissions.replace("-", "").length(), (int)permissions.size());
        }
        if (expectedPermissions != null) {
            permissions = Files.getPosixFilePermissions(this.testFile(testFilePath), LinkOption.NOFOLLOW_LINKS);
            Assertions.assertEquals((Object)expectedPermissions, (Object)PosixFilePermissions.toString(permissions));
            Assertions.assertEquals((int)expectedPermissions.replace("-", "").length(), (int)permissions.size());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:write666").to(FileProducerDirectoryChmodOptionTest.this.fileUri("?chmodDirectory=777&chmod=666"))).to("mock:chmod666");
                ((RouteDefinition)this.from("direct:write0755").to(FileProducerDirectoryChmodOptionTest.this.fileUri("?chmodDirectory=777&chmod=0755"))).to("mock:chmod0755");
                ((RouteDefinition)this.from("direct:writeNoDir").to(FileProducerDirectoryChmodOptionTest.this.fileUri("?chmod=0755"))).to("mock:chmodNoDir");
            }
        };
    }
}

