/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Date;
import java.util.Set;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS})
public class FileProducerChmodOptionTest
extends ContextTestSupport {
    @Test
    public void testWriteValidChmod0755() throws Exception {
        this.runChmodCheck("0755", "rwxr-xr-x");
    }

    @Test
    public void testWriteValidChmod666() throws Exception {
        this.runChmodCheck("666", "rw-rw-rw-");
    }

    private void runChmodCheck(String routeSuffix, String expectedPermissions) throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:chmod" + routeSuffix);
        mock.expectedMessageCount(1);
        String testFileName = "chmod" + routeSuffix + ".txt";
        String testFileContent = "Writing file with chmod " + routeSuffix + " option at " + String.valueOf(new Date());
        mock.expectedFileExists(this.testFile(testFileName), testFileContent);
        this.template.sendBodyAndHeader("direct:write" + routeSuffix, (Object)testFileContent, "CamelFileName", (Object)testFileName);
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(this.testFile(testFileName), LinkOption.NOFOLLOW_LINKS);
        Assertions.assertEquals((Object)expectedPermissions, (Object)PosixFilePermissions.toString(permissions));
        Assertions.assertEquals((int)expectedPermissions.replace("-", "").length(), (int)permissions.size());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalidChmod() {
        FailedToCreateRouteException e = (FailedToCreateRouteException)Assertions.assertThrows(FailedToCreateRouteException.class, () -> this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:writeBadChmod1").to(FileProducerChmodOptionTest.this.fileUri("?chmod=abc"))).to("mock:badChmod1");
            }
        }), (String)"Expected FailedToCreateRouteException");
        FileProducerChmodOptionTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
        PropertyBindingException pbe = FileProducerChmodOptionTest.assertIsInstanceOf(PropertyBindingException.class, e.getCause().getCause());
        Assertions.assertEquals((Object)"chmod", (Object)pbe.getPropertyName());
        IllegalArgumentException iae = FileProducerChmodOptionTest.assertIsInstanceOf(IllegalArgumentException.class, pbe.getCause());
        Assertions.assertTrue((boolean)iae.getMessage().contains("chmod option [abc] is not valid"));
    }

    @Test
    public void testWriteNoChmod() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:noChmod");
        mock.expectedMessageCount(1);
        String testFileName = "noChmod.txt";
        String testFileContent = "Writing file with no chmod option at " + String.valueOf(new Date());
        mock.expectedFileExists(this.testFile(testFileName), testFileContent);
        this.template.sendBodyAndHeader("direct:writeNoChmod", (Object)testFileContent, "CamelFileName", (Object)testFileName);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:write666").to(FileProducerChmodOptionTest.this.fileUri("?chmod=666"))).to("mock:chmod666");
                ((RouteDefinition)this.from("direct:write0755").to(FileProducerChmodOptionTest.this.fileUri("?chmod=0755"))).to("mock:chmod0755");
                ((RouteDefinition)this.from("direct:writeNoChmod").to(FileProducerChmodOptionTest.this.fileUri())).to("mock:noChmod");
            }
        };
    }
}

