/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.converter.stream.InputStreamCache;
import org.junit.jupiter.api.Test;

public class FileProducerChecksumFileAlgorithmTest
extends ContextTestSupport {
    @Test
    public void testProducerChecksumFileMd5() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?checksumFileAlgorithm=md5"), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        FileProducerChecksumFileAlgorithmTest.assertFileExists(this.testFile("hello.txt"));
        FileProducerChecksumFileAlgorithmTest.assertFileExists(this.testFile("hello.txt.md5"), "b10a8db164e0754105b7a99be72e3fe5");
    }

    @Test
    public void testProducerChecksumFileSha256() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?checksumFileAlgorithm=sha256"), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        FileProducerChecksumFileAlgorithmTest.assertFileExists(this.testFile("hello.txt"));
        FileProducerChecksumFileAlgorithmTest.assertFileExists(this.testFile("hello.txt.sha256"), "a591a6d40bf420404a011733cfb7b190d62c65bf0bcda32b57b277d9ad9f146e");
    }

    @Test
    public void testProducerChecksumFileSha256WithStreamCaching() throws Exception {
        InputStreamCache cache = new InputStreamCache("Hello World".getBytes());
        this.template.sendBodyAndHeader(this.fileUri("?checksumFileAlgorithm=sha256"), (Object)cache, "CamelFileName", (Object)"hello.txt");
        FileProducerChecksumFileAlgorithmTest.assertFileExists(this.testFile("hello.txt"));
        FileProducerChecksumFileAlgorithmTest.assertFileExists(this.testFile("hello.txt.sha256"), "a591a6d40bf420404a011733cfb7b190d62c65bf0bcda32b57b277d9ad9f146e");
    }
}

