/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileProducerCharsetUTFtoUTFTest
extends ContextTestSupport {
    private static final String DATA = "ABC\u00e6";
    private static final String INPUT_FILE = "input." + FileProducerCharsetUTFtoUTFTest.class.getSimpleName() + ".txt";
    private static final String OUTPUT_FILE = "output." + FileProducerCharsetUTFtoUTFTest.class.getSimpleName() + ".txt";

    FileProducerCharsetUTFtoUTFTest() {
    }

    @Test
    void testFileProducerCharsetUTFtoUTF() throws Exception {
        byte[] source = DATA.getBytes(StandardCharsets.UTF_8);
        try (OutputStream fos = Files.newOutputStream(this.testFile(INPUT_FILE), new OpenOption[0]);){
            fos.write(source);
        }
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        FileProducerCharsetUTFtoUTFTest.assertFileExists(this.testFile(OUTPUT_FILE));
        byte[] target = Files.readAllBytes(this.testFile(OUTPUT_FILE));
        Assertions.assertArrayEquals((byte[])source, (byte[])target, (String)("The byte arrays should be equals but they are not.\n Source:\n" + new String(source) + "\nTarget:\n" + new String(target)));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.fromF(FileProducerCharsetUTFtoUTFTest.this.fileUri("?initialDelay=0&delay=10&fileName=%s"), new Object[]{INPUT_FILE}).toF(FileProducerCharsetUTFtoUTFTest.this.fileUri("?fileName=%s&charset=utf-8"), new Object[]{OUTPUT_FILE});
            }
        };
    }
}

