/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FileProducerCharsetUTFtoISOTest
extends ContextTestSupport {
    private static final String DATA = "ABC\u00e6";

    FileProducerCharsetUTFtoISOTest() {
    }

    @BeforeEach
    void writeFile() throws Exception {
        try (OutputStream fos = Files.newOutputStream(this.testFile("input.FileProducerCharsetUTFtoISOTest.txt"), new OpenOption[0]);){
            fos.write(DATA.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Test
    void testFileProducerCharsetUTFtoISO() throws Exception {
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        FileProducerCharsetUTFtoISOTest.assertFileExists(this.testFile("output.FileProducerCharsetUTFtoISOTest.txt"));
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> {
            byte[] data = Files.readAllBytes(this.testFile("output.FileProducerCharsetUTFtoISOTest.txt"));
            Assertions.assertEquals((Object)DATA, (Object)new String(data, StandardCharsets.ISO_8859_1));
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileProducerCharsetUTFtoISOTest.this.fileUri("?initialDelay=0&delay=10&fileName=input.FileProducerCharsetUTFtoISOTest.txt")).to(FileProducerCharsetUTFtoISOTest.this.fileUri("?fileName=output.FileProducerCharsetUTFtoISOTest.txt&charset=iso-8859-1"));
            }
        };
    }
}

