/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FileProducerCharsetUTFtoISOConvertBodyToTest
extends ContextTestSupport {
    private static final String DATA = "ABC\u00e6";
    private static final String INPUT_FILE = "input." + FileProducerCharsetUTFtoISOConvertBodyToTest.class.getSimpleName() + ".txt";
    private static final String OUTPUT_FILE = "output." + FileProducerCharsetUTFtoISOConvertBodyToTest.class.getSimpleName() + ".txt";

    FileProducerCharsetUTFtoISOConvertBodyToTest() {
    }

    @BeforeEach
    void writeTestData() {
        try (OutputStream fos = Files.newOutputStream(this.testFile(INPUT_FILE), new OpenOption[0]);){
            fos.write(DATA.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            Assertions.fail((String)("The test cannot run due to: " + e.getMessage()));
        }
    }

    @AfterEach
    void cleanupFile() {
        try {
            Files.delete(this.testFile(OUTPUT_FILE));
        }
        catch (IOException e) {
            Assertions.fail((String)("The test cannot run due to an error cleaning up: " + e.getMessage()));
        }
    }

    @Test
    void testFileProducerCharsetUTFtoISOConvertBodyTo() throws Exception {
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        Path outputFile = this.testFile(OUTPUT_FILE);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> FileProducerCharsetUTFtoISOConvertBodyToTest.assertFileExists(outputFile));
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertTrue((Files.size(outputFile) > 0L ? 1 : 0) != 0));
        byte[] data = Files.readAllBytes(outputFile);
        Assertions.assertEquals((Object)DATA, (Object)new String(data, StandardCharsets.ISO_8859_1));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.fromF(FileProducerCharsetUTFtoISOConvertBodyToTest.this.fileUri("?initialDelay=0&delay=10&fileName=%s&charset=utf-8"), new Object[]{INPUT_FILE}).convertBodyTo(byte[].class, "iso-8859-1")).setProperty("CamelCharsetName", (Expression)this.header("someCharsetHeader"))).toF(FileProducerCharsetUTFtoISOConvertBodyToTest.this.fileUri("?fileName=%s"), new Object[]{OUTPUT_FILE});
            }
        };
    }
}

