/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileProducerCharsetUTFtoISOConfiguredTest
extends ContextTestSupport {
    private static final String DATA = "ABC\u00e6";
    private static final String INPUT_FILE = "input." + FileProducerCharsetUTFtoISOConfiguredTest.class.getSimpleName() + ".txt";
    private static final String OUTPUT_FILE = "output." + FileProducerCharsetUTFtoISOConfiguredTest.class.getSimpleName() + ".txt";

    FileProducerCharsetUTFtoISOConfiguredTest() {
    }

    @Test
    void testFileProducerCharsetUTFtoISO() throws Exception {
        try (OutputStream fos = Files.newOutputStream(this.testFile(INPUT_FILE), new OpenOption[0]);){
            fos.write(DATA.getBytes(StandardCharsets.UTF_8));
        }
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        FileProducerCharsetUTFtoISOConfiguredTest.assertFileExists(this.testFile(OUTPUT_FILE));
        byte[] data = Files.readAllBytes(this.testFile(OUTPUT_FILE));
        Assertions.assertEquals((Object)DATA, (Object)new String(data, StandardCharsets.ISO_8859_1));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.fromF(FileProducerCharsetUTFtoISOConfiguredTest.this.fileUri("?initialDelay=0&delay=10&charset=utf-8&fileName=%s"), new Object[]{INPUT_FILE}).toF(FileProducerCharsetUTFtoISOConfiguredTest.this.fileUri("?fileName=%s&charset=iso-8859-1"), new Object[]{OUTPUT_FILE});
            }
        };
    }
}

