/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileProducerCharsetUTFOptimizedTest
extends ContextTestSupport {
    private final byte[] utf = "ABC\u00e6D\ud867\ude3dE\ud83c\udff3".getBytes(StandardCharsets.UTF_8);

    @BeforeEach
    public void createData() throws IOException {
        this.testDirectory("input", true);
        this.log.debug("utf: {}", (Object)new String(this.utf, StandardCharsets.UTF_8));
        for (byte b : this.utf) {
            this.log.debug("utf byte: {}", (Object)b);
        }
        try (OutputStream fos = Files.newOutputStream(this.testFile("input/input.txt"), new OpenOption[0]);){
            fos.write(this.utf);
        }
    }

    @Test
    public void testFileProducerCharsetUTFOptimized() throws Exception {
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertTrue((boolean)Files.exists(this.testFile("output.txt"), new LinkOption[0]), (String)"File should exist");
        byte[] data = Files.readAllBytes(this.testFile("output.txt"));
        Assertions.assertArrayEquals((byte[])this.utf, (byte[])data);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileProducerCharsetUTFOptimizedTest.this.fileUri("input?initialDelay=0&delay=10&noop=true")).to(FileProducerCharsetUTFOptimizedTest.this.fileUri("?fileName=output.txt"));
            }
        };
    }
}

