/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class FileProducerAllowNullBodyTest
extends ContextTestSupport {
    @Order(value=1)
    @Test
    @DisplayName(value="Tests that an empty file named allowNullBody.txt will be created")
    public void testAllowNullBodyTrue() {
        this.template.sendBody(this.fileUri("?allowNullBody=true&fileName=allowNullBody.txt"), null);
        Path path = this.testFile("allowNullBody.txt");
        FileProducerAllowNullBodyTest.assertFileExists(path);
        long size = path.toFile().length();
        Assertions.assertEquals((long)0L, (long)size);
    }

    @Order(value=2)
    @Test
    @DisplayName(value="Tests that a non-empty file named allowNullBody.txt will be created and then truncated")
    public void testAllowNullBodyTrueTruncate() {
        this.template.sendBody(this.fileUri("?allowNullBody=true&fileName=allowNullBody.txt"), (Object)"Hello");
        Path path = this.testFile("allowNullBody.txt");
        FileProducerAllowNullBodyTest.assertFileExists(path);
        long sizeBeforeTruncate = path.toFile().length();
        Assertions.assertNotEquals((long)0L, (long)sizeBeforeTruncate);
        this.template.sendBody(this.fileUri("?allowNullBody=true&fileName=allowNullBody.txt"), null);
        FileProducerAllowNullBodyTest.assertFileExists(path);
        long sizeAfterTruncate = path.toFile().length();
        Assertions.assertEquals((long)0L, (long)sizeAfterTruncate);
    }

    @Order(value=3)
    @Test
    @DisplayName(value="Tests that an exception will be thrown if allowNullBody is absent and a null body is sent")
    public void testAllowNullBodyFalse() {
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody(this.fileUri("?fileName=allowNullBody.txt"), null), (String)"Should have thrown a GenericFileOperationFailedException");
        GenericFileOperationFailedException cause = FileProducerAllowNullBodyTest.assertIsInstanceOf(GenericFileOperationFailedException.class, e.getCause());
        Assertions.assertTrue((boolean)cause.getMessage().endsWith("allowNullBody.txt"));
        Assertions.assertFalse((boolean)Files.exists(this.testFile("allowNullBody.txt"), new LinkOption[0]), (String)"allowNullBody set to false with null body should not create a new file");
    }
}

