/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileProducerAllowNullBodyFileAlreadyExistsTest
extends ContextTestSupport {
    public static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testFileExistAppendAllowNullBody() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello world", "CamelFileName", (Object)TEST_FILE_NAME);
        MockEndpoint mock = this.getMockEndpoint("mock:appendTypeAppendResult");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME), "Hello world");
        this.template.sendBody("direct:appendTypeAppend", null);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFileExistOverrideAllowNullBody() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello world", "CamelFileName", (Object)TEST_FILE_NAME);
        MockEndpoint mock = this.getMockEndpoint("mock:appendTypeOverrideResult");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME), "");
        this.template.sendBody("direct:appendTypeOverride", null);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:appendTypeAppend").setHeader("CamelFileName", (Expression)this.constant(TEST_FILE_NAME))).to(FileProducerAllowNullBodyFileAlreadyExistsTest.this.fileUri("?allowNullBody=true&fileExist=Append"))).to("mock:appendTypeAppendResult");
                ((RouteDefinition)((RouteDefinition)this.from("direct:appendTypeOverride").setHeader("CamelFileName", (Expression)this.constant(TEST_FILE_NAME))).to(FileProducerAllowNullBodyFileAlreadyExistsTest.this.fileUri("?allowNullBody=true&fileExist=Override"))).to("mock:appendTypeOverrideResult");
            }
        };
    }
}

