/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFileProducer;
import org.junit.jupiter.api.Test;

public class FileProduceTempPrefixTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_1 = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_2 = "claus" + String.valueOf(UUID.randomUUID()) + ".txt";
    public static final String FILE_QUERY = "?tempPrefix=inprogress.";

    @Test
    public void testCreateTempFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri(FILE_QUERY));
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)TEST_FILE_NAME_2);
        String tempFileName = producer.createTempFileName(exchange, this.testFile(TEST_FILE_NAME_2).toString());
        FileProduceTempPrefixTest.assertDirectoryEquals(this.testFile("inprogress." + TEST_FILE_NAME_2).toString(), tempFileName);
    }

    @Test
    public void testCreateTempFileNameUsingComplexName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri(FILE_QUERY));
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)("foo/" + TEST_FILE_NAME_2));
        String tempFileName = producer.createTempFileName(exchange, this.testFile("foo/" + TEST_FILE_NAME_2).toString());
        FileProduceTempPrefixTest.assertDirectoryEquals(this.testFile("foo/inprogress." + TEST_FILE_NAME_2).toString(), tempFileName);
    }

    @Test
    public void testNoPathCreateTempFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri(FILE_QUERY));
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)TEST_FILE_NAME_2);
        String tempFileName = producer.createTempFileName(exchange, ".");
        FileProduceTempPrefixTest.assertDirectoryEquals("inprogress." + TEST_FILE_NAME_2, tempFileName);
    }

    @Test
    public void testTempPrefix() {
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME_1);
        FileProduceTempPrefixTest.assertFileExists(this.testFile(TEST_FILE_NAME_1));
    }

    @Test
    public void testTempPrefixUUIDFilename() {
        this.template.sendBody("direct:a", (Object)"Bye World");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").to(FileProduceTempPrefixTest.this.fileUri(FileProduceTempPrefixTest.FILE_QUERY));
            }
        };
    }
}

