/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFileProducer;
import org.junit.jupiter.api.Test;

public class FileProduceTempFileNameTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_CLAUS = "claus" + String.valueOf(UUID.randomUUID());
    public static final String FILE_URL_QUERY = "tempandrename?tempFileName=inprogress-${file:name.noext}.tmp";
    public static final String PARENT_FILE_URL_QUERY = "tempandrename?tempFileName=../work/${file:name.noext}.tmp";
    public static final String CHILD_FILE_URL_QUERY = "tempandrename?tempFileName=work/${file:name.noext}.tmp";

    @Test
    public void testCreateTempFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri(FILE_URL_QUERY));
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)(TEST_FILE_NAME_CLAUS + ".txt"));
        String tempFileName = producer.createTempFileName(exchange, this.testFile(TEST_FILE_NAME_CLAUS + ".txt").toString());
        FileProduceTempFileNameTest.assertDirectoryEquals(this.testFile("inprogress-" + TEST_FILE_NAME_CLAUS + ".tmp").toString(), tempFileName);
    }

    @Test
    public void testNoPathCreateTempFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri(FILE_URL_QUERY));
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)(TEST_FILE_NAME_CLAUS + ".txt"));
        String tempFileName = producer.createTempFileName(exchange, ".");
        FileProduceTempFileNameTest.assertDirectoryEquals("inprogress-" + TEST_FILE_NAME_CLAUS + ".tmp", tempFileName);
    }

    @Test
    public void testTempFileName() {
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProduceTempFileNameTest.assertFileExists(this.testFile("tempandrename/" + TEST_FILE_NAME));
    }

    @Test
    public void testParentTempFileName() {
        this.template.sendBodyAndHeader("direct:b", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProduceTempFileNameTest.assertDirectoryExists(this.testDirectory("work"));
    }

    @Test
    public void testChildTempFileName() {
        this.template.sendBodyAndHeader("direct:c", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        FileProduceTempFileNameTest.assertDirectoryExists(this.testDirectory("tempandrename/work"));
    }

    @Test
    public void testCreateParentTempFileName() throws Exception {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri(PARENT_FILE_URL_QUERY));
        GenericFileProducer producer = (GenericFileProducer)endpoint.createProducer();
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("CamelFileName", (Object)(TEST_FILE_NAME_CLAUS + ".txt"));
        String tempFileName = producer.createTempFileName(exchange, this.testFile("tempandrename/" + TEST_FILE_NAME_CLAUS + ".txt").toString());
        FileProduceTempFileNameTest.assertDirectoryEquals(this.testDirectory("work/" + TEST_FILE_NAME_CLAUS + ".tmp").toString(), tempFileName);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").to(FileProduceTempFileNameTest.this.fileUri(FileProduceTempFileNameTest.FILE_URL_QUERY));
                this.from("direct:b").to(FileProduceTempFileNameTest.this.fileUri(FileProduceTempFileNameTest.PARENT_FILE_URL_QUERY));
                this.from("direct:c").to(FileProduceTempFileNameTest.this.fileUri(FileProduceTempFileNameTest.CHILD_FILE_URL_QUERY));
            }
        };
    }
}

