/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.HashMap;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Test;

public class FileProduceOverruleTest
extends ContextTestSupport {
    public static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";
    public static final String TEST_FILE_NAME_OVERRULE = "overrule." + String.valueOf(UUID.randomUUID()) + ".txt";
    public static final String TEST_FILE_NAME_RULED = "ruled." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testNoOverrule() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)TEST_FILE_NAME);
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME), "Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnlyOverrule() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).header("CamelFileName")).isNull();
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME_OVERRULE), "Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelOverruleFileName", (Object)TEST_FILE_NAME_OVERRULE);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBoth() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)TEST_FILE_NAME);
        ((MockValueBuilder)mock.message(0).header("CamelOverruleFileName")).isNull();
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME_RULED), "Hello World");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CamelFileName", TEST_FILE_NAME);
        map.put("CamelOverruleFileName", TEST_FILE_NAME_RULED);
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", map);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to(new String[]{FileProduceOverruleTest.this.fileUri(), "mock:result"});
            }
        };
    }
}

