/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.HashMap;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileProduceOverruleOnlyOnceTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_1 = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_2 = "ruled" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testBoth() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)TEST_FILE_NAME_1);
        ((MockValueBuilder)mock.message(0).header("CamelOverruleFileName")).isNull();
        mock.expectedFileExists(this.testFile("write/" + TEST_FILE_NAME_2), "Hello World");
        mock.expectedFileExists(this.testFile("again/" + TEST_FILE_NAME_1), "Hello World");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CamelFileName", TEST_FILE_NAME_1);
        map.put("CamelOverruleFileName", TEST_FILE_NAME_2);
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", map);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to(FileProduceOverruleOnlyOnceTest.this.fileUri("write"))).to(new String[]{FileProduceOverruleOnlyOnceTest.this.fileUri("again"), "mock:result"});
            }
        };
    }
}

