/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileProduceGeneratedFileNameTest
extends ContextTestSupport {
    @Test
    public void testGeneratedFileName() {
        Endpoint endpoint = this.context.getEndpoint("direct:a");
        FileEndpoint fileEndpoint = this.resolveMandatoryEndpoint(this.fileUri(), FileEndpoint.class);
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        String id = fileEndpoint.getGeneratedFileName(exchange.getIn());
        this.template.send(endpoint, exchange);
        Assertions.assertTrue((boolean)Files.exists(this.testFile(id), new LinkOption[0]), (String)("The generated file should exists: " + id));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").to(FileProduceGeneratedFileNameTest.this.fileUri());
            }
        };
    }
}

