/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileProduceAppendCharsTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testAppendChars() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedFileExists(this.testFile(TEST_FILE_NAME), "Hello\nWorld\nHow are you?\n");
        this.template.sendBody("direct:start", (Object)"Hello");
        this.template.sendBody("direct:start", (Object)"World");
        this.template.sendBody("direct:start", (Object)"How are you?");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setHeader("CamelFileName", (Expression)this.constant(TEST_FILE_NAME))).to(new String[]{FileProduceAppendCharsTest.this.fileUri("?fileExist=Append&appendChars=\\n"), "mock:result"});
            }
        };
    }
}

