/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilePollingConsumerTest
extends ContextTestSupport {
    @Test
    public void testPollingConsumer() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        PollingConsumer consumer = this.context.getEndpoint(this.fileUri()).createPollingConsumer();
        consumer.start();
        Exchange exchange = consumer.receive(5000L);
        Assertions.assertNotNull((Object)exchange);
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody(String.class));
        Awaitility.await().pollDelay(500L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assertions.assertDoesNotThrow(() -> this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt")));
        Awaitility.await().pollDelay(1000L, TimeUnit.MILLISECONDS).untilAsserted(() -> Assertions.assertTrue((boolean)Files.exists(this.testFile("bye.txt"), new LinkOption[0]), (String)"File should exist bye.txt"));
        consumer.stop();
    }
}

