/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilePollEnrichTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testFilePollEnrich() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists(this.testFile("done/" + TEST_FILE_NAME));
        this.template.sendBodyAndHeader("file:" + String.valueOf(this.testDirectory()), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertFalse((boolean)Files.exists(this.testFile(TEST_FILE_NAME), new LinkOption[0]), (String)"File should have been moved");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("timer:foo?period=1000").routeId("foo").log("Trigger timer foo")).pollEnrich(FilePollEnrichTest.this.fileUri("?move=done"), 5000L)).convertBodyTo(String.class)).log("Polled filed ${file:name}")).to("mock:result");
            }
        };
    }
}

