/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FilePollEnrichNoWaitTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @BeforeEach
    public void sendMessage() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
    }

    @Test
    public void testFilePollEnrichNoWait() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists(this.testFile("done/" + TEST_FILE_NAME));
        this.oneExchangeDone.matchesWaitTime();
        mock.assertIsSatisfied(Duration.ofSeconds(2L).toMillis());
        Assertions.assertFalse((boolean)Files.exists(this.testFile("hello.txt"), new LinkOption[0]), (String)"File should have been moved");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("timer:foo?delay=0&period=10").routeId("foo").log("Trigger timer foo")).pollEnrich(FilePollEnrichNoWaitTest.this.fileUri("?initialDelay=0&delay=10&move=done"), 0L)).convertBodyTo(String.class)).filter(this.body().isNull()).stop()).end().log("Polled filed ${file:name}").to("mock:result");
            }
        };
    }
}

