/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class FileNoOpLockFileTest
extends ContextTestSupport {
    @Test
    public void testLocked() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Locked"});
        this.template.sendBodyAndHeader(this.fileUri("locked"), (Object)"Hello Locked", "CamelFileName", (Object)"report.txt");
        mock.assertIsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> this.existsLockFile(false));
        this.checkLockFile(false);
    }

    @Test
    public void testNotLocked() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Not Locked"});
        this.template.sendBodyAndHeader(this.fileUri("notlocked"), (Object)"Hello Not Locked", "CamelFileName", (Object)"report.txt");
        mock.assertIsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> this.existsLockFile(false));
        this.checkLockFile(false);
    }

    private boolean existsLockFile(boolean expected) {
        String filename = (expected ? "locked/" : "notlocked/") + "report.txt.camelLock";
        return expected == Files.exists(this.testFile(filename), new LinkOption[0]);
    }

    private void checkLockFile(boolean expected) {
        String filename = (expected ? "locked/" : "notlocked/") + "report.txt.camelLock";
        Assertions.assertEquals((Object)expected, (Object)Files.exists(this.testFile(filename), new LinkOption[0]), (String)("Lock file should " + (expected ? "exists" : "not exists")));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileNoOpLockFileTest.this.fileUri("locked/?initialDelay=0&delay=10&noop=true&readLock=markerFile")).process((Processor)new MyNoopProcessor())).to("mock:report");
                ((RouteDefinition)this.from(FileNoOpLockFileTest.this.fileUri("notlocked/?initialDelay=0&delay=10&noop=true&readLock=none")).process((Processor)new MyNoopProcessor())).to("mock:report");
            }
        };
    }

    private class MyNoopProcessor
    implements Processor {
        private MyNoopProcessor() {
        }

        public void process(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            boolean locked = "Hello Locked".equals(body);
            FileNoOpLockFileTest.this.checkLockFile(locked);
        }
    }
}

